; Script para o jogo Show do Milho Grande 6.
; Desenvolvido em Outubro de 2010.
; por Marcos Antonio de Oliveira.
; E-mail: mao-mail@uol.com.br
; Equipe Cegueta
; www.cegueta.com


Include "HJconst.jsh"
include "hjglobal.jsh"
Include "common.jsm"
Include "smg6.jsh"
Include "smg6.jsm"

Globals
; handles utilizadas nas funes de evento
handle globalRealwindow,
handle globalPrevWindow,
string GlobalRealWindowName,
handle GlobalAppWindow,
string GlobalPrevObjectName ,
string GlobalObjectName,
; Variveis Inteiras globais
int giSmg6Inicio, ; falso se for a primeira vez que o jogo for iniciado numa sesso do Jaws.
Int giFlagSetas, ; 1= ativa o funcionamento das setas verticais com as listas virtuais, 0= desativa.
Int giControle, ; recebe o Id do controle que se quer acionar com o mouse.
int giLiberaPergunta, ; quando verdadeiro libera o anncio da pergunta.
int giTotalJogadores,
int giPalavraPergunta, ; ndice que varia entre a primeira e a ltima palavra da pergunta atual.
int giIndice, ; ndice que indica o tem selecionado na lista virtual.
int giIndiceAuxiliar, ; Recebe a Cpia do ndice do tem selecionado das alternativas das questes.
int giModoEscolha, ; 0= sem lista virtual, 1=lista de matrias, 2=lista das alternativas, 3=lista das ajudas.
; strings globais
String gsLista, ; recebe as listas das matrias, alternativas ou ajudas.
String gsListaAuxiliar, ; recebe a cpia da lista de alternativas no momento em que se pede ajuda.
string gsAuxiliar, ; varivel auxiliar genrica.
string gsIdListaAlternativas, ; Lista dos IDs das alternativas disponveis.
String gsPergunta, ; varivel que recebe a pergunta atual.
string gsSoletra, ; varivel que recebe a ltima alternativa selecionada ou a ltima palavra selecionada com f3 para efetuar a soletrao.
String gsAlternativaEscolhida, ; recebe a alternativa escolhida.
string gsNomeJogador, ; varivel que recebe o nome do jogador atual.
string gsListaAjudaAtual, ; recebe a lista das ajudas disponveis.
String gsListaIdsAjudas ; recebe uma lista com os IDs das ajudas disponveis.


Void Function AutoStartEvent ()
if !giSmg6Inicio 
&& telas()==1 then
let giControle=8
else
let giControle=-1
endif
let giFlagSetas=0
EndFunction




Void Function MouseButtonEvent (int n, int x, int y)
if n!=WM_LBUTTONDOWN  then
return
endif
if GetCurrentControlId()>=idQuartaAlternativa && GetCurrentControlId()<=idPrimeiraAlternativa then
let giFlagSetas=false
let giPalavraPergunta=0
let gsSoletra=cscNull
let giLiberaPergunta=false
let giModoEscolha=2
say (StringSegment(obterAlternativas(),"|",108-getcurrentcontrolid()), ot_message)
return
Elif Getcurrentcontrolid()==idJogar then
let giFlagSetas=False
let giIndice=false
let gsLista=cscNull
let giLiberaPergunta=true
let giModoEscolha=2

return
Elif getcurrentcontrolid()==idSimParar then
let giFlagSetas=false
let gsLista=cscNull
delay (30)
say (Formatstring(msgParou,ObterNomeJogador(x),inttostring(x)),ot_Screen_Message)
if x<10000 
|| x==500000
then
delay (8)
say (msgCovarde,ot_Screen_message)
endif
return
Elif telas ()==2 then 
SaveCursor()
RouteJawsToPc()
JawsCursor()
SetRestriction (restrictnone)
moveto(x,y)
delay (2)

if getword()!=cscNull
&& getwindowtypecode(getCurrentwindow())!=wt_edit then
say (getword(), ot_screen_message)
endif
restorecursor()
return


Endif

EndFunction




Script JogadorAtual ()
if telas()!=3 then
say(msgForaJanelaPrincipal,ot_error)
return
endif
if stringsegmentcount(gsNomeJogador,"-")>1 then
say (formatstring(msgVezParticipant, stringsegment(gsNomejogador,"-",1),stringsegment(gsNomejogador,"-",2)),ot_Screen_message)
else
say (formatstring(msgParticipante, stringsegment(gsNomejogador,"-",1)),ot_Screen_message)
EndIf
EndScript

String Function ObterNomeJogador (int ByRef Valor)
var
string aux
let aux=stringreplacesubstrings(gsNomeJogador," - ","|")
let valor=stringtoint(stringsegment(aux,"|",2))
return stringsegment(aux,"|",1)

EndFunction


Script PedirAjuda ()
; Ativa a lista de ajudas

if telas()!=3 then
say (msgForaJanelaPrincipal,ot_error)
return
endif
var
string aux,
string nomeAjuda,
int valor,
int n,
int x

let gsListaAjudaAtual=cscNull
let gsListaIdsAjudas=cscNull
let x=1
while x<=6
let aux=stringsegment(idListaAjudas,"|",x)
let n=stringToInt(aux)
if !isWindowDisabled(FindDescendantWindow (GlobalRealwindow, n)) 

then
let NomeAjuda=stringsegment(listaAjudas,"|",x)
if x>=4 then
let NomeAjuda=FormatString(msgOrdemPulos, inttostring(x-3)) 
Endif
let gsListaAjudaAtual=gsListaAjudaAtual+NomeAjuda+"|"
let gsListaIdsAjudas=gsListaIdsAjudas+stringsegment(IdListaAjudas,"|",x)+"|"
if x==4 || x==5 then
let x=9
endif
endif
let x=x+1
endwhile
if !StringSegmentCount(gsListaAjudaAtual,"|") then
say (msgSemAjuda, ot_error)
return
endif
obterNomejogador(Valor)
If valor==500000 then
say (msgSemAjudaFinal,ot_error)
return
EndIf
let gsListaAuxiliar=gsLista
let giIndiceAuxiliar=giIndice
let giModoEscolha=3
say(msgEscolherAjuda,ot_Screen_Message)
delay (7)
let giFlagSetas=true

let gsLista=gsListaAjudaAtual
let giIndice=1
say (stringsegment(gsLista,"|",giIndice), ot_Screen_Message)
EndScript



Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle hReal,
	handle hAppWindow,
	string RealName,
	int iSubType
let GlobalFocusWindow=FocusWindow
let hReal=GetRealWindow(FocusWindow)
Let RealName = GetWindowName (hReal)
let hAppWindow=GetAppMainWindow(FocusWindow)
let GlobalRealWindow=hReal
let GlobalRealWindowName=RealName
let GlobalAppWindow=hAppWindow
let globalPrevWindow=getAppmainwindow(PrevWindow)
let GlobalFocusWindow = FocusWindow
let GlobalPrevObjectName = GlobalObjectName
let GlobalObjectName=GetObjectName(TRUE)
if (GlobalPrevApp != hAppWindow && hAppWindow != FocusWindow) then
	If (! GlobalWasHjDialog) || InHjDialog () then
		If ! HandleCustomAppWindows (hAppWindow) then
			SayWindowTypeAndText (hAppWindow)
		EndIf
	EndIf
endIf
If ((GlobalPrevRealName != RealName) ; name has changed
|| (GlobalPrevReal != hReal)) then ; or handle has changed, then
	If ((hReal != hAppWindow) && (hReal != FocusWindow)) then
		If ! HandleCustomRealWindows (hReal) then

			SayWindowTypeAndText (hReal)
		EndIf ; End of HandleCustomReal check
	EndIf ; End of Real window isn't appWindow or Focus Window. check
endIf ; End of Real window check.
If ! HandleCustomWindows (FocusWindow) then
	SayFocusedWindow()
EndIf
;FocusChangedEvent (FocusWindow, PrevWindow)


let GlobalPrevApp=hAppWindow
let GlobalPrevReal=hReal
let GlobalPrevRealName=RealName
let GlobalPrevFocus=FocusWindow
EndFunction

Void Function HandleCustomAppWindows (handle Win)
delay (5)
if telas()==2 
&& gicontrole!=idJogarInicial 
then
PlaySound(FindJAWSSoundFile ("login.wav" ))

return true

endif
return false
EndFunction
Void Function HandleCustomRealWindows (handle Win)
if telas()==1 
&& giControle!=idPlacar 
then
let gicontrole=idJogarInicial
say (msgJanelaInicial,ot_Screen_Message)
delay (6)
setfocus(FindDescendantWindow (globalrealwindow, idJogarInicial))
Pause()
IndicateControlType(wt_button,stringSegment(ListaInicial,"|", 1),cscnull)
return true
endif
return false
EndFunction
Void Function HandleCustomWindows (handle Win)
var
string aux,
Int x
if GetcurrentControlId()>=idOitavoParticipante&& getCurrentControlId()<=idPrimeiroParticipante 
&& telas()==2
&& getWindowTypeCode(win)==wt_edit
then
if GetWindowTypeCode (GlobalPrevFocus )!=wt_Edit then
delay (25)
endif
IndicateControlType(wt_edit,Formatstring(msgParticipante, IntToString(34-GetCurrentControlId())), getwindowtext(win,0))
return true
Elif getcurrentcontrolid()>=idJogarInicial && getcurrentcontrolid()<=idSair 
&& telas()==1
then
IndicateControlType (wt_button, stringsegment(listaInicial,"|",getcurrentcontrolid()-7), cscNull)
return true
Endif
Return False
EndFunction


Void Function WindowCreatedEvent (HANDLE WIN, int left, int top, int right, int bottom)
var 
int x,
string lista,
string ordem, string rodadas, string nome, string valor,
string aux
if giControle==idPlacar 
&& !iswindowdisabled(FindDescendantWindow (globalrealwindow, idPlacar))
then
; para fornecer informaes da lista do placar
delay (15)
speechoff()
; montando a lista do placar
savecursor()
routejawstopc()
jawscursor()
;SetRestriction (restrictwindow)
jawsPageUp()
if !stringcontains(getline(),"0") then
say ("O placar est vazio" , ot_message)
delay (6)
say (msgVoltandoTelaInicial,ot_message )
pause()
let giControle=3
acionacontrole (gicontrole)
return
endif


let x=1
while x<=10
&& getcurrentwindow()==FindDescendantWindow (globalrealwindow, 1)
jawshome()
let ordem=getword()
nextword()
let rodadas=getword()
nextword()
let nome=GetTextBetween (getcursorcol(), 03000 )
nextword()
let valor=getword()
let nome=stringreplacesubstrings(nome,valor,CscNull)
if Valor=="1000000" then
let valor=msgUmMilhao
EndIf

let aux=FormatString(msgInfoPlacar,ordem,nome,rodadas,valor)
if !stringcontains(lista,aux) then
let lista =lista+aux+"|"
else
let x=10
endif
nextline()
let x=x+1
endWhile
restorecursor()
speechon()
; exibindo a lista do placar
DlgSelectItemInList(Lista,msgListaPlacar,0,1)
pause()
; voltando para tela inicial
say (msgVoltandoTelaInicial,ot_message )
let  giControle=3
AcionaControle(idVoltarPlacar)
let gicontrole=idJogarInicial
return
Elif   getwindowname(win)==Wn_JanelaInicial 
&& giControle!=idPlacar
then
; Foco na janela inicial
let giFlagSetas=False
let giIndice=0
let gsLista=cscNull
let gsPergunta=cscnull
let gsAuxiliar=cscNull
let gsAlternativaEscolhida=cscNull
delay (7)
Say("Janela Inicial",ot_Screen_Message)
let giControle=idJogarInicial
delay (5)
IndicateControlType (wt_button, stringsegment(listainicial,"|",1), cscNull)
pause()
endif
EndFunction

void Function NewTextEvent(handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
var
int x, int y,
string aux, string aux1,
handle win
let win=FindDescendantWindow (globalrealwindow, 1)
if stringcontains (stringupper(buffer), stringupper("ilho")) then
saystring ("ganhou um milh")
return
endif 
if getcontrolid(hwnd)==idControlePlacas 
&& gsAuxiliar==cscNull
then
; obter a maior porcentagem das placas

let aux=getwindowtext(hwnd,0)
let aux=stringChopLeft(aux,1)+" "
let gsAuxiliar="xxx" 
Let aux=stringreplacesubstrings(aux," ",cscNull)
let x=1
let y=0
while x<=4
let aux1=stringsegment(aux,"%",x)
if stringToInt(aux1)>y then
let y=stringToInt(aux1)
endif
let x=x+1
EndWhile
let giIndice=stringsegmentIndex(aux,"%",intToString(y),true)
let aux=stringsegment(gsLista,"|",giIndice)
Delay (5)
say (Formatstring(msgRespostaPlacas, inttostring(y), inttostring(giIndice), aux),ot_Screen_message)
return
endif
if getcontrolid(hwnd)==idControleUniversitarios 
&& gsAuxiliar==cscnull
then
; obter a  alternativa escolhida pelos universitrios
let aux=getwindowtext(hwnd,0)
let gsAuxiliar="xxx"
let aux=stringright(aux,1)
let giIndice=stringtoInt(aux)
delay (6)
say(FormatString(msgRespostaUniversitarios,aux,stringsegment(gslista,"|",giIndice)),ot_Screen_Message)
return
endif
if ntextcolor==65535  
&& telas()==3
then
; obtm  o nome do jogador atual
let gsNomeJogador=buffer
endif
if  ntextcolor==16777215
&& telas()==3
&& !giLiberaPergunta
&& !stringcontains(idListaAjudas,inttostring(giControle))
&& giModoEscolha==0 
then
let gsAuxiliar=buffer+"|"+inttostring (getcontrolid(hwnd))
ScheduleFunction ("Resposta", 6)
return
endif

if telas ()==3 
&& nTextColor==16777215
&& nBackGroundColor==11431279
then
let gsAuxiliar=cscNull
let giFlagSetas=true
let gsLista=cscNull
let gsPergunta=cscnull
let giLiberaPergunta=true
let giModoEscolha=2
return
Elif getControlid(hWnd)>=104 && getcontrolid(hWnd)<=107 
then
if !giLiberaPergunta
then
return
endif
;let gsLista=gsLista+getwindowtext (hWnd,0)+"|"
let giFlagSetas=true
if  getcontrolid(hwnd)==idQuartaAlternativa 
then
let gsLista=ObterAlternativas()
let gsPergunta=ObterPergunta()
say(gsPergunta,ot_Screen_message)
let giLiberaPergunta=false
let giPalavraPergunta=0
let gsSoletra=cscNull
endif
return
endif
;NewTextEvent(hwnd, buffer, nAttributes, nTextColor, nBackgroundColor, nEcho, sFrameName)
EndFunction


String Function ObterPergunta ()
; retorna uma string com a pergunta
var
handle win,
int x,
string aux
let win=FindDescendantWindow (globalrealwindow, 1)
savecursor()

routejawstopc()
jawscursor()
movetowindow(win)
pause()

jawspageup()
if giTotalJogadores>1 then
nextline()
endif
let x=1
while x<=10 
nextline()
jawshome()
nextcharacter()

if stringupper(obternomecor())==stringupper("white on light slate gray")
||  stringupper(obternomecor())==stringupper("branco on lousa claro cinza")
||   stringupper(obternomecor())==stringupper("branco sobre lousa claro cinza")
|| stringupper(obternomecor())==stringupper("branco sobre MeioProla4")
|| stringupper(obternomecor())==stringupper("branco on MeioProla4")
|| stringupper(obternomecor())==stringupper("white on MediumPurple4")
|| (!stringcontains(getline(),getwindowtext(FindDescendantWindow (globalrealwindow, 107),0))
&&  !stringcontains(getline(),getwindowtext(FindDescendantWindow (globalrealwindow, 106),0))
 && !stringcontains(getline(),getwindowtext(FindDescendantWindow (globalrealwindow, 105),0))
&& !stringcontains(getline(),getwindowtext(FindDescendantWindow (globalrealwindow, 104),0)))
then
let aux=aux+getline()+" "
endif
let x=x+1
;nextline()
endwhile
restorecursor()
return aux
EndFunction



String Function ObterAlternativas ()
; retorna para a varivel gsLista as alternativas para a questo
var
int x,
string aux,
handle win
let gsIdListaAlternativas=cscNull
let x=idPrimeiraAlternativa
while x>=idQuartaAlternativa
let win=FindDescendantWindow (Globalrealwindow, x)
if !isWindowDisabled(win) 
;|| IsWindowVisible (win)
then
let aux=aux+getWindowText(win,0)+"|"
let gsIdListaAlternativas=gsIdListaAlternativas+IntToString(x)+"|"
endif
let x=x-1
EndWhile
return aux
EndFunction

String Function ObterStatusMaterias (string Materia)
; retorna um texto com o status da matria selecionada.
; retornar marcada ou no marcada
var
int x,
string aux,
handle win
let win=FindDescendantWindow (getappmainwindow(getfocus()), 1); controle principal
let aux=getwindowtext(win,0)
let aux="# "+aux+" #"
let aux=stringreplacesubstrings(aux,Materia,"|")
let x=stringsegmentcount(aux,"|")
if x==2 then
return msgNaoMarcada
else
return msgMarcada
endif

EndFunction

Script AlternarBanco ()
var 
handle win,
string aux,
string lista,
int x

; alterna entre o uso do banco de dados principal e o personalizado.
if telas()!=2 then
 say (msgForaJanelaParticipantes, ot_error)
return
EndIf
If giFlagSetas then
say(msgSairModoEscolha, ot_error)
return
Endif

let lista=scBanco2006+"|"+scBancoPersonalizado
let win=getappmainwindow(getcurrentwindow())
let x=getwindowbottom(FindDescendantWindow (getappmainwindow(getfocus()), idoitavoparticipante))
let aux=GetTextInRect (getwindowleft(win),x , getwindowright(win), getwindowbottom(win), 0, ignorecolor, 8388608 )
let x=StringSegmentIndex(lista,"|",aux, true)
let x=x+1-2*(x==2)
savecursor()
jawscursor()
SetRestriction (restrictnone)
jawspageDown()
jawshome()
if Findstring(getappmainwindow(getfocus()), stringsegment(lista,"|",x), S_top, s_unrestricted) then
delay (2)
leftmousebutton()
SayUsingVoice (VCTX_PcCursor, Formatstring(msgTrocaBanco, aux, stringsegment(lista,"|",x)) ,ot_Screen_Message )

endif
restorecursor()

EndScript



Script Editor ()
var
string aux

let aux=GetAppFilePath ()
let aux=stringreplacesubstrings(aux,GetAppFileName (),"Editor.exe")
 let aux="\34"+aux+"\34"
Say (msgAbrindoEditor, ot_Message)
delay (25)
run ("tskill smg6 /a")
Run (aux)


EndScript


Script RecarregarJanela ()
; atualiza a janela atual e suas variveis
var
handle win
if telas()!=3 then
let win=FindTopLevelWindow ("ThunderRT5Form",cscNull)
if !iswindowvisible(win) then
setfocus(win)
pause()
endif
RefreshScreen()
endif
pause()
;Show do Milho 6  
if telas()==1 then
let giControle=idJogarInicial
say (msgJanelaInicial, ot_Screen_Message)
delay (10)
IndicateControlType(wt_button,stringsegment(listainicial,"|",1), cscNull)
let giFlagSetas=false
return
Elif telas()==2 then
let giFlagSetas=false
say(msgTelaCadastro,ot_Screen_message)
delay (20)
let win=FindDescendantWindow (GlobalRealWindow, idPrimeiroParticipante)
if getfocus()!=win then
setfocus (win)
else 
IndicateControlType (wt_edit, formatstring (msgParticipante,"1"), getwindowtext(win,0))
endif
return
Elif telas ()==3 then
 let giLiberaPergunta=true
let giModoEscolha=2
let gsLista=ObterAlternativas()
let gsNomeJogador=ObterNomeJogador(0)
PerformScript RepetirPergunta()
if  0 then ;gsPergunta==cscnull then
let gsPergunta=ObterPergunta()
say (gsPergunta, ot_Screen_Message)
endif
let giIndice=0
let giPalavraPergunta=0
let giFlagSetas=true
return
endif
EndScript


Void Function Resposta ()
var
; retorna a resposta certa para a questo atual
string nome,
Int valor, int alternativa
let alternativa=stringtoint((stringsegment(gsAuxiliar,"|",2)))
let gsAuxiliar=stringsegment(gsAuxiliar,"|",1)

if stringSegmentcount (gsAuxiliar," ")<4
&& StringCompare(StringUpper(gsAuxiliar),StringUpper(gsAlternativaEscolhida))!=0
&& giIndiceAuxiliar!=Alternativa
then
let giLiberapergunta=false
let gsAlternativaEscolhida=gsAuxiliar
say(FormatString(msgRespostaCorreta,gsAuxiliar),ot_Screen_message)
let nome=obterNomeJogador(Valor)
let valor=valor/2
delay (4)
say (FormatString(msgGanhou,nome,inttostring(valor)), ot_Screen_Message)
if valor<=10000 then
delay (5)
say (msgFraquinho,ot_screen_message)
endif
endif
let giLiberaPergunta=true

EndFunction

Script Parar ()
; aciona o boto parar
if Telas()!=3 then
say (msgForaJanelaPrincipal, ot_error)
return
endif
if isWindowvisible(FindDescendantWindow (globalrealwindow, idParar)) then
say (msgParar, ot_Screen_message)
let giControle=idParar
AcionaControle(giControle)
endif

EndScript

Script ConverterParaMinusculas ()
if Telas()!=3 then
say (msgForaJanelaPrincipal, ot_error)
return
endif
let gsLista=StringLower (gsLista)
let gsPergunta=StringLower (gsPergunta)



EndScript


Script TabShiftTab (int n)
; cria um foco virtual para a janela inicial
; mantm o foco sobre as caixas de edio na janela dos participantes
var
handle win,
Int Controle
let win=getappmainwindow(getfocus())
let win=getfirstchild(win)
if  Telas()<1
&&  Telas()>2
 then
SayCurrentScriptKeyLabel ()
TypeCurrentScriptKey ()
return
endif


If Telas()==1 then
if !n then
let giControle=giControle+1-5*(giControle==idSair)
Else
Let giControle=giControle-1+5*(giControle==idJogarInicial)
endif
IndicateControlType(wt_Button,stringSegment(ListaInicial,"|",giControle-7), cscNull)
return
Elif telas()==2 then
if !n 
&& getcurrentcontrolid()==idOitavoParticipante then
setfocus(FindDescendantWindow (globalrealwindow, idPrimeiroParticipante))
pause()
return
Elif n
&& getcurrentcontrolid()==idPrimeiroParticipante then
setfocus(FindDescendantWindow (globalrealwindow, idOitavoParticipante))
pause()
return
endif
TypeCurrentScriptKey ()
endif

EndScript
Script Enter ()
var
handle win,
string aux,
int x, int k
SayCurrentScriptKeyLabel ()
If InHJDialog () then
; se estiver numa janela do jaws
TypeCurrentScriptKey ()
return
endif
if isWindowVisible(FindDescendantWindow (globalRealwindow, idSimParar)) 
&& telas()==3
then
; se estiver visvel o boto para confirmar a a parada do jogo, ativa-o.
let giFlagSetas=false
let gsLista=cscNull
let giControle=idSimParar
AcionaControle (giControle)
delay (30)
say (Formatstring(msgParou,ObterNomeJogador(x),inttostring(x)),ot_Screen_Message)
if x<10000 
|| x==500000
then
; se o valor obtido for menor a dez mil ou se disistir no arrisca tudo
delay (8)
say (msgCovarde,ot_Screen_message)
endif
return
EndIf
If iswindowvisible (FindDescendantWindow (GlobalRealWindow, idSimCerteza))
&& telas()==3
then
; acionamento do boto que confirma a alternativa escolhida
let giControle=idSimCerteza
let win=FindDescendantWindow (GlobalRealWindow, idSimCerteza)
delay (2)
ClickAtPoint((getwindowleft(win)+getwindowright(win))/2,(getwindowtop(win)+getwindowbottom(win))/2,0)
let giPalavraPergunta=0
let gsSoletra=cscNull
;let giIndice=0
let giModoEscolha=0
let giControle=idSimCerteza
let giLiberaPergunta=false
let gsPergunta=cscNull
let giFlagSetas=false

return
Endif
if telas()==1 then
; acionamento dos botes da janela inicial
let giFlagSetas=false
if giControle==idJogarInicial 
|| giControle==idPlacar
then
AcionaControle (giControle) 
return
Elif giControle==idJogarOnLine then
say (msgNaoImplementaddo, ot_Screen_message)
return
Elif giControle==idCreditos then
VirtualizaTexto(msgCreditos)
return
Elif giControle==idSair then
PerformScript Sair()
return
endif ; fim acionamento dos controles da tela inicial

Elif telas()==2  then
; acionamento dos controles da janela  de participantes e matrias
if  giFlagSetas then
; se estiver no modo escolha de matrias
if isWindowDisabled(FindDescendantWindow (globalrealwindow, idJogar)) then
; se o boto jogar estiver desabilitado sai do 
; anuncia mensagem e sai do script
say (msgSemEscolhaMaterias, ot_error)
return 
endif
; acionamento do boto jogar
let giFlagSetas=False
let giIndice=false
let gsLista=cscNull
let giLiberaPergunta=true
let giModoEscolha=2
let gicontrole=idJogar

Acionacontrole (gicontrole)
return
else 
; no est no modo escolha de matrias 
; verificar se foi digitado pelo menos o nome de um jogador
let x=1
let k=0
let giTotalJogadores=0
while x<=8  
if getwindowtext(FindDescendantWindow (globalrealwindow, 34-x),0)!=cscNull then
let k=k+1
let giTotaljogadores=k
endif
let x=x+1
endwhile
if !k then
; no foi digitado o nome para nenhum jogador
; anuncia mensagem e sai do script
say (msgSemEscolhaParticipantes, ot_error)
return
endif
; ativa o modo escolha de matrias
EscolherMaterias()
return
endif ; fim controles para a tela de participantes e matrias
Elif telas()==3 && giFlagSetas 
&& giIndice!=0 
&& giModoEscolha==2
then
; aciona o controle da alternativa escolhida
let giControle=StringToInt(StringSegment(gsIdListaAlternativas,"|",giIndice))
let giIndiceAuxiliar=giControle
let gsAlternativaEscolhida=stringsegment(gslista,"|",giIndice)

let x=AcionaControle (giControle)
if ! x  then
return
endif
let giFlagSetas=false
let giPalavraPergunta=0
let gsSoletra=cscNull
let giLiberaPergunta=false
return
Elif telas()==3
&& giModoEscolha==3
then
; acionamento dos controles de aajuda
let aux=stringSegment(gsListaIdsAjudas,"|",giIndice)
let giControle=StringToInt(aux)
let giLiberaPergunta=true
let gimodoEscolha=2
AcionaControle(Gicontrole)
if stringcontains(stringsegment(gsListaAjudaAtual,"|",giIndice), scPlacas) 
|| stringcontains(stringsegment(gsListaAjudaAtual,"|",giIndice), scUniversitarios)
then
; se foi escolhida as placas ou universitrios
; Restaura a lista das alternativas e do ndice salvos ao pedir ajuda
let gsLista=gsListaAuxiliar
;let giIndice=giIndiceAuxiliar
elif stringcontains(stringsegment(gsListaAjudaAtual,"|",giIndice), scPular) then
; se foi escolhida a opo pular
let giIndice=0
let giLiberaPergunta=true
let gsLista=cscNull
return

 elif stringcontains(stringsegment(gsListaAjudaAtual,"|",giIndice), scCartas) then
;se foi escolhida as cartas
let giControle=idCarta1
AcionaControle1(giControle); clica na primeira carta
delay(3)
; verificando qual carta foi sorteada
; atravs das alternativas que continuam habilitadas
; e atualiza a lista das alternativas
let giIndice=1
let gsLista=ObterAlternativas()
let k=StringSegmentCount (gsLista,"|")
let aux=stringsegment(listaCartas,"|",k)
say (Formatstring(msgRespostaCartas,aux),ot_Screen_Message)
if k==4  then
say (msgSemSorte, ot_Screen_message)
Elif k==1 then
say (formatString (msgTirouUm3,IntToString (k), stringsegment(gsLista,"|",k)), ot_Screen_message)
endif

endif

return
endif
TypeCurrentScriptKey ()
EndScript


Script Sair ()
; fora o fechamento do jogo a partir de qualquer janela
var
string arquivo
let arquivo=FindJAWSSoundFile ("tchau.wav" )
PlaySound (arquivo)
delay (20)
run ("tskill smg6 /a")


EndScript
Script Regras ()
; exibe uma tela virtualizada com as regras do jogo
VirtualizaTexto(msgRegras)
EndScript

Script Ajuda ()
;virtualiza texto com as informaes dos atalhos para o script
VirtualizaTexto(msgAjuda)
EndScript

Void Function VirtualizaTexto (string msg)
; virtualiza textos recebidos pela varivel texto.
if UserBufferIsActive () then 
UserBufferDeactivate() 
EndIf
sayFormattedMessage(ot_user_Buffer,msg)
EndFunction
Void Function EscolherMaterias ()
; inicializa a lista virtual para escolha das matrias
var
handle win,
string aux,
string materia,
int x

let win=FindDescendantWindow (getappmainwindow(getfocus()), 1); controle principal
let aux=getwindowtext(win,0)
;let aux=stringUpper(aux)
let gsLista=ObterMaterias()
/*
let x=1
while x<=8
let materia=stringsegment(ListaMaterias,"|",x)
if Stringcontains(aux, (materia)) then 
let gsLista=gsLista+materia+"|"
endif
let x=x+1
endwhile
*/
if  !stringsegmentcount(gsLista,"|") then
say (msgSemMateriasCadastradas, ot_error)
return
endif
let giFlagSetas=True
let giIndice=0
let giModoEscolha=1
PlaySound (FindJAWSSoundFile ("HarpStringLong.wav" ))
pause()
Say (msgModoEscolhaMaterias,ot_Screen_message)
EndFunction

Script Setas (int Direcao)
; coordena o funcionamento das setas nas listas virtuais
var
string aux

If  MenusActive ()
|| !IsPCCursor ()
|| InHJDialog ()
| UserBufferIsActive ()
|| !giFlagSetas
then
if direcao==0 then
PerformScript saypriorline()
elif direcao==1 then
PerformScript saynextline()
endif
return
endif
var
int TotalItens,
int x,
String item
let TotalItens=StringSegmentcount(gsLista,"|")
let giPalavraPergunta=0
if !direcao then
let giIndice=giIndice-1+TotalItens*(giIndice==1)+(TotalItens+1)*(giIndice==0)

else
let giIndice=giIndice+1-TotalItens*(giIndice==TotalItens)

Endif
let aux=StringSegment(gsLista,"|", giIndice)
Say (aux,ot_Screen_message)
if telas()==2 then
say (ObterStatusMaterias(stringsegment(gsLista,"|", giIndice)),ot_Status)

elif telas()==3 then
let gsSoletra=StringLower (aux)
endif
EndScript

Script SpaceBar ()
; marca matrias e ativa controles
var
 int left, int right, int top, int bottom, int x, int y,
Handle win,
string aux

if  !giFlagSetas 
&&  (telas()!=2
&&  telas()!=1)
&&   giControle!=-1
then
SayCurrentScriptKeyLabel ()
TypeCurrentScriptKey ()
return
EndIf
; para tela do vdeo de abertura
if  gicontrole<0 
&& !giFlagsetas
then
let win=getcurrentwindow()

if  getcontrolid(win)==1 then
let left=getwindowleft(win)
let right=getwindowright(win)
let top=getwindowtop(win)
let bottom=getwindowbottom(win)
let x=(left+right)/2
let y=(top+bottom)/2
clickatpoint (x,y,0)
endif
return
Endif

if telas()==1 then
SayCurrentScriptKeyLabel ()
if giControle==idJogarInicial 
|| giControle==idPlacar
then
ACionaControle(giControle)
return
Elif giControle==idJogarOnLine then
say (msgNaoImplementaddo, ot_Screen_message)
return
Elif giControle==idCreditos then
VirtualizaTexto(msgCreditos)
return
Elif giControle==IdSair then
PerformScript Sair()
return
endif
return
Endif ; fim controles tela inicial

; incio da parte que marca ou desmarca uma matria selecionada na lista virtual
if !giIndice  then
; nenhuma matria est selecionada
return
endif
speechoff()

let win=FindDescendantWindow (globalrealwindow, 1); janela principal da tela
let aux=ObterStatusmaterias(stringsegment(gslista,"|",giIndice))
; aux recebe o status atual da matria selecionada
; abaixo, procura a matria com a cor que indica que est ativa para clicar com o mouse
savecursor()
RouteJawsToPc()
jawscursor()
SetRestriction (restrictnone)
JawsPageUp()
JawsHome()
let x=1
while  x<=100
if getword()==StringSegment(gsLista,"|",giIndice)
&& (!stringcompare(obterNomeCor(),"white on Slate Blue4")
|| stringcontains(obternomecor(),"branco on Azul Ardsia4")
|| stringcontains(obternomecor(),"branco sobre Azul Ardsia4"))


then
nextCharacter()
delay (3)
LeftMouseButton ()
let x=999
Endif ; fim findString
let x=x+1
nextword()
endwhile
restoreCursor()
if x==100 then 
say (msgSemMateriasCadastradas, ot_error)
return
endif
PcCursor()
; escolhe do boto para marcar ou desmarcar a matria
speechOn()
if !stringCompare(aux,scNaoMarcada) then
SayUsingVoice (vctx_PcCursor, msgMarcada, ot_Status)
let giControle=idMarcarMateria
AcionaControle (giControle)
else
SayUsingVoice (vctx_PcCursor, msgNaoMarcada, ot_Status)
let giControle=idDesmarcarMateria
AcionaControle (giControle)
endif; Fimm materia marcada no marcada

EndScript

String Function ObterMaterias ()
var
string lista,
string aux, int x

savecursor()
routeJawstopc()
jawscursor()
SetRestriction (restrictnone)
jawspagedown()
jawsEnd()
let x=1
while x<=100
&& !stringcontains(getword(),scBanco2006)
let aux=getword()
if  (!stringcompare(obterNomeCor(),"white on Slate Blue4") 
|| Stringcontains(obternomecor(),"branco on Azul Ardsia4")
|| stringcontains(obternomecor(),"branco sobre Azul Ardsia4"))
&& !stringcontains(lista, aux)
&& !stringcontains(aux,scBancoPersonalizado)
then
let lista=lista+aux+"|"
endif
priorword ()
let x=x+1
Endwhile
Restorecursor()
return lista

EndFunction

Script Escape ()
; desativa o modo escolha de matrias e o modo ajuda
; fecha a janela do placar
var
handle win
if !giFlagSetas 
&&  UserBufferIsActive ()
then
SayCurrentScriptKeyLabel ()
UserBufferDeactivate ()
TypeCurrentScriptKey ()
return
Elif giModoEscolha==3 then
; est no modo ajuda
let giModoEscolha=2 ; volta ao modo escolha alternativas
; recarrega a lista  e o ndice que foram salvos ao entrar no modo ajuda 
let gsLista=gsListaAuxiliar
let giIndice=giIndiceAuxiliar
let giFlagSetas=true
say (msgCancelado, ot_error)
return
ElIf giFlagSetas==1 
&& telas()==2
then
; se estiver no modo escolha matrias

let win=FindDescendantWindow (globalrealwindow, idPrimeiroParticipante)
let giFlagSetas=false
PlaySound (FindJAWSSoundFile ("HarpStringLong.wav" ))
pause()
say (msgSaindoModoMaterias,Ot_Screen_message)
if getfocus()!=win then
; foca a caixa de edio do primeiro participante
setfocus(win)
endif
pause()
if getcurrentcontrolid()==33 then
IndicateControlType (wt_edit, formatstring(msgParticipante,"1"), getwindowtext(getfocus(),0))
endif
return
Elif isWindowvisible(FindDescendantWindow (globalrealwindow, idNaoCerteza)) then
; acionando o boto de para no confirmar a alternativa escolhidade parar
say(msgCancelado,ot_error)
let giControle=idNaoCerteza
AcionaControle(giControle)
let giModoEscolha=2
let giFlagSetas=true
return
Elif isWindowVisible (FindDescendantWindow (globalrealwindow, idNaoParar)) 
&& telas()==3
then
say (msgCancelado,ot_error)
let giFlagSetas=true
let giControle=idNaoParar
AcionaControle (giControle)
return
endif

SayCurrentScriptKeyLabel ()
TypeCurrentScriptKey ()
EndScript




Script Voltar ()
; retorna da tela dos participantes e matrias para a janela inicial
if telas()!=2 then
SayCurrentScriptKeyLabel ()
TypeCurrentScriptKey ()
return
endif
Say (msgVoltandoTelaInicial,ot_Screen_message)
AcionaControle1(idVoltarTelaInicial)


EndScript

Script RepetirPergunta ()
; repete a a pergunta atual
if Telas()!=3 then
say (msgForaJanelaPrincipal, ot_error)
return
endif
if gsPergunta!=cscnull then
say (gsPergunta,OT_USER_REQUESTED_INFORMATION)
else
say (obterpergunta(),OT_USER_REQUESTED_INFORMATION)
endif
EndScript

Script PalavrasPergunta ()
; fala a pergunta atual palavra por palavra
if Telas()!=3 then
say (msgForaJanelaPrincipal, ot_error)
return
endif
var
string aux,
int n
let n=stringsegmentcount(gsPergunta," ")
let giPalavraPergunta=giPalavraPergunta+1-n*(giPalavraPergunta==n)
let aux=stringsegment(gsPergunta," ", giPalavraPergunta)
 say(aux, ot_Screen_Message)
let gsSoletra=StringLower (aux)


EndScript

Script SoletraPalavra ()
; soletra a palavra escolhida na pergunta ou a ltima alternativa dita.
if Telas()!=3 then
say (msgForaJanelaPrincipal, ot_error)
return
endif
SpellString (gsSoletra)


EndScript

Int Function AcionaControle (int controle)
; funo que aciona os controles determinados pela varivel global giControle
var
handle win,
int left, int top, int right, int bottom
speechoff()
let win=getappmainwindow(getfocus())
let win=FindDescendantWindow (win, giControle)
let left=getwindowleft(win)
let right=getwindowright(win)
let top=getwindowtop(win)
let bottom=getwindowbottom(win)
speechoff()
if  win then
savecursor()
routejawstopc()
jawscursor()
SetRestriction (Restrictnone)
moveto((left+right)/2,(top+bottom)/2)
if getcurrentcontrolid()!=giControle then
speechon()
return false
endif
delay (4)
leftmousebutton()
Restorecursor()
pcCursor()
speechon()
return true
endif
speechon()
return false
EndFunction
Int Function AcionaControle1 (int controle)
var
handle win,
int left, int top, int right, int bottom
speechoff()
let win=getrealwindow(getfocus())

let win=FindDescendantWindow (globalrealwindow, controle)
if win then
let left=getwindowleft(win)
let right=getwindowright(win)
let top=getwindowtop(win)
let bottom=getwindowbottom(win)

savecursor()
jawscursor()
SetRestriction (restrictnone)
movetowindow(win)
delay (4)
moveto((left+right)/2,(top+bottom)/2)
delay (4)
leftmousebutton()
restorecursor()
speechon()

return true

endif
speechon()

return false
EndFunction
Int Function Telas ()
; retorna un nmero que indica a tela atual
;1=janela inicial
; 2= escolha das matrias e participantes
;3= tela principal das perguntas
; 4= tela do placar

if getwindowname(getappmainwindow(getfocus()))==Wn_JanelaInicial then
return 1
Elif iswindowvisible(FindDescendantWindow (getappmainwindow(getfocus()), idPrimeiroParticipante )) then
return 2
Elif iswindowvisible(FindDescendantWindow (getappmainwindow(getfocus()), idParar )) then
return 3
Elif iswindowvisible(FindDescendantWindow (getappmainwindow(getfocus()), idVoltarPlacar )) then
return 4
Elif iswindowvisible(FindDescendantWindow (getappmainwindow(getfocus()), idComum)) then
Return 5
endif
return 0

EndFunction
Void Function RefreshScreen ()
;atualiza a janela atual e as variveis
ReloadSystemColors()
Refresh ()
MSAARefresh ();So Refresh accurately reloads all cached data
BrailleRefresh();All Braille segments, allows BrailleCallbackObjectIdentify and helpers to use new MSAA data if necessary.
ResetVoiceSettings ()
;EscapeFromApplet ()
EndFunction
String Function ObterNomeCor ()
; retorna o nome da cor na posio do cursor ativo
var
int bSpeakRGB,
int textColor,
int backgroundColor,
string textColorName,
string backgroundColorName,
string sMessage

let textColor=GetColorText()
let backgroundColor=GetColorBackground()
	let textColorName=StringMixedCaseToMultiword(GetColorName(textColor))
let backgroundColorName=StringMixedCaseToMultiword(GetColorName(backgroundColor))
let sMessage=FormatString(cmsgColorInfo,textColorName,backgroundColorName)
Return sMessage
EndFunction